#version 330
#extension GL_EXT_gpu_shader4 : enable
//Raining ColumnsMod01.fsh   by  ircss
//https://www.shadertoy.com/view/4sKfDz
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177 //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float rand(float Seed){
    
    return fract(sin(Seed*4124213.)*37523.);
}

float rand(vec2 Seed){
    
    return fract(sin(dot(Seed, vec2(241512.,5124.632))*5124.124));
}

float randInRange(float id, vec2 range){
    
    id = rand(id);
    return range.x + id * (range.y-range.x);
}


void AddPannedGrid( inout vec4 FragCol, vec2 uv, vec4 GridColor,
                   vec2 panningSpeedRange, float gridSize, float seedDiff){
    

    float verticalStretch = 1.;
    vec2 st = uv;
    
    // This value tells you the index of the columns and rows. You might have 
    // to recalculate it if you pan something
    vec2 gridID = floor ( vec2(uv.x * gridSize, uv.y *verticalStretch));
    
    
    // Paning the texture
    
    uv.y+= rand(gridID.x+14. +seedDiff) +randInRange(gridID.x+seedDiff, panningSpeedRange)*iTime;
    
    // divide the uv so that it creates the grid
    uv = fract ( vec2(uv.x * gridSize , uv.y *verticalStretch));
   
    
    // Shading the grids
    float diagonal = smoothstep(0.,0.05, uv.y - uv.x*.1*st.y);

    vec3 temp = vec3((1.-uv.x)*pow((1.0-uv.y)*1.2,4.))*diagonal;
    
    
    // Applying the alpha and the fin color addtiv on top
    FragCol.xyz += GridColor.a * GridColor.xyz*temp;
    
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;

    // Compensating for aspect ration
    uv.x *= iResolution.x/iResolution.y;
    
    vec4 finalColor = vec4(0.314159);
    
    // Adding the efect Additiv
	AddPannedGrid(finalColor, uv, vec4(0.4,0.7,1.,0.5), vec2(.4,.7), 13., 123.);
    AddPannedGrid(finalColor, uv, vec4(0.4,0.7,1.,0.9), vec2(.4,.7), 10.,45.26);
    AddPannedGrid(finalColor, uv, vec4(0.4,0.7,1.,0.2), vec2(.4,.9), 16.,53.1);
    
    // Output to screen
    gl_FragColor = finalColor;
}